% Script-File BspLogit.m
%
% Aufruf:  BspLogit
%
% Beispiel zur VERALLGEMEINERTEN LINEAREN Regression.
% Es wird fr die Daten aus der Datei Kauf.dat ein LOGIT-Modell berechnet.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 13.10.2003/2.7.2004

% Laden der Daten aus Kauf.dat

load Kauf.dat
x = Kauf(:,1); y = Kauf(:,2);

% Aufruf der Funktion glmfit zur Berechnung des Logit-Modells

beta = glmfitB(x,[y, ones(size(y))], 'binomial','logit',[],[],[],'on')

% Berechnung der Anpassungskurve und Darstellung mit den
% Daten aus Kauf.dat

yfit = glmvalB(beta,x,'logit');

scatter(x, y, 30, 'r-', 'filled');
xlabel('Jahreseinkommen/Euro', 'FontSize', 14)
ylabel('Kaufentscheidung/ja=1,nein=0', 'FontSize', 14)
set(gca, 'FontSize', 14)

hold
[xsort, Indx] = sort(x);       % Daten aufsteigend sortieren
plot(xsort, yfit(Indx), 'b-', 'LineWidth', 3);

strg1 = cellstr(['Kaufwahrscheinlichkeit']);    
text(5*10^4,0.5, strg1, 'FontSize', 14);

