% Script-File BspMultipRegress.m
%
% Aufruf:  BspMultipRegress
%
% Beispiel zur MULTIPLEN LINEAREN Regression.
% Es werden Datenpunkte erzeugt, die einer linearen Vorschrift in zwei Variablen gengen.
% Um fr die Zielgre Messungenauigkeiten zu simulieren, werden diese mit Hilfe eines
% Zufallsgenerators mit normalverteilten Werten "`gestrt"'. Anschlieend wird
% mit der Toolbox-Funktion regress lineare Regression berechnet.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 20.10.2003

% Erzeugung von 7 Datenpunkten (im Raster [0 1]x[0 1])

x1 = rand(7,1);      % 7 Punkte x1 (zufllig gewhlt)
x2 = rand(7,1);      % 7 Punkte x2 (als Spaltenvektoren)

sigma = 0.05;        % Steuung der normalverteilten Strung

                     % Zielgrenwerte mit normalverteilten
                     % "Strungen" der Messwerte erzeugen                   
randn('state',sum(100*clock));
y = 2*x1-x2+1+sigma*randn(7,1);

% Werte 3-dimensional darstellen

scatter3(x1,x2,y,100,'k', 'filled');
xlabel('x_1', 'FontSize', 14)
ylabel('x_2', 'FontSize', 14)
zlabel('Zielgre y', 'FontSize', 14)
set(gca, 'FontSize', 14)

% Regressionsebene berechnen

X = [x1, x2, ones(length(x1),1)];
[beta, bint, r, rint, stats] = regressB(y,X)


% Darstellung der Regressionsebene

xw = (0:0.1:1); yw = xw;
[X,Y] = meshgrid(xw,yw);
Rf = beta(1)*X+beta(2)*Y+beta(3);
hold
surf(xw,yw,Rf)


axis([0,1,0,1,0,3.5])                       % Anpassung der Achsen
set(gca, 'XTick', (0:0.2:1));
xtn = ['  0'; '0.2'; '0.4'; '0.6'; '0.8'; '  1'];
set(gca, 'XTickLabel', xtn)
set(gca, 'XTick', (0:0.2:1));
ytn = xtn;
set(gca, 'YTickLabel', ytn)
set(gca, 'ZTick', (0:0.5:3.5));
ztn = ['  0'; '0.5'; '  1'; '1.5'; '  2'; '2.5'; '  3'; '3.5'];
set(gca, 'YTickLabel', ytn)
view(40,42)