% Script-File BspNLdist.m
%
% Aufruf:  BspNLdist
%
% Beispiel zur NICHTLINEAREN Regression.
% Dieses Script ermittelt die Regressionsparameter eines NICHTLINEAREN 
% Modells fr ein auf Galileo zurckgehendes Fallexperiment.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 20.11.2003/2.7.2004

% Laden der Daten aus galileoExp1.dat

load galileoExp1.dat
dist = galileoExp1(:,1);
hoeh = galileoExp1(:,2);

% Bestimmung eines Startvektors

beta = [1/max(dist),-1/max(dist)];

% Berechnung der Modellparameter mit nlinfit

[betahat, R, J] = nlinfitB(hoeh,dist,@NLdist,beta);

% Berechnung der Anpassungskurve und Darstellung mit den
% Daten aus galileoExp1.dat

dfit = NLdist(betahat, hoeh);

scatter(hoeh,dist, 60, 'r-', 'filled');
xlabel('Hhe/Punkte', 'FontSize', 14)
ylabel('Distanz/Punkte', 'FontSize', 14)
set(gca, 'FontSize', 14)
hold
[xsort, Indx] = sort(hoeh);       % Daten aufsteigend sortieren
plot(xsort, dfit(Indx), 'b-', 'LineWidth', 3);

% Vertrauensintervalle berechnen
% (ENTFLLT, da nlparci nicht zur Verfgung gestellt wird)
% betaKonfInt = nlparci(betahat, R, J);