% Script-File BspUrnenExp2StabHfg.m
%
% Aufruf:  BspUrnenExp2StabHfg
%
% Beispiel zur Wahrscheinlichkeits"definition" mittels Stabilisierung
% der Hufigkeiten.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 2.9.2003/27.6.2004


% Vorinitialisierung der relativen Hufigkeiten
Hfgk = []; 

% Aufruf von UrnenExp2StabHfg.m in Schritten zu 500 Versuchen
for versuche = 500:500:20000
    [relH] = UrnenExp2StabHfg([1 2 3], versuche, 5, 3);
    Hfgk = [Hfgk, relH]; 
end;

% Ergebnis grafisch darstellen und dem Laplace-Wert 0.048 
% gegenberstellen
trials = (1:1:40);
plot( trials, Hfgk, 'r-', trials, 0.048*ones(1,length(Hfgk)), 'b-', ...
       'LineWidth', 3);
xlabel('Versuche/mal 500','FontSize', 14)
ylabel('rel. Hufigkeit','FontSize', 14)
set(gca, 'FontSize', 14)



