% Script-File Bspbootstrp2.m
%
% Aufruf:  Bspbootstrp2
%
% Beispiel zur Bootstrap-Technik. Schtzung des Modalwertes der Daten
% aus verbrauch.dat mit Hilfe der Statistics Toolbox Funktion bootstrp.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 24.12.2003

% Klassenmitten mssen ber eine globale Variable an
% die Funktion EmpModal2 bergeben werden!

global klmitten

% Laden der Daten

load verbrauch.dat
dx = 0.1;
klmitten = (7.5:dx:11.5);    % Klassenmitten und Breiten dx def.

% Berechnung der Bootstrap-Statistiken mit bootstrp

[ModW, BootSamples] = bootstrpB(200, @EmpModal2, verbrauch);

% Zweiseitige alpha-Quantile der Modalwerte berechnen

alpha = 0.05;

Gu = prctileB(ModW,100*alpha/2)
Go = prctileB(ModW,100*(1-alpha/2))