% Script-File CpWertIllu.m
%
% Aufruf: CpWertIllu
%
% MATLAB-Script zur grafischen Visualisierung des C_p-Wertes
% mit Hilfe von normspec fr ideale und nicht ideale Prozesslage.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 10.2.2004


T_u = 19.985; T_o = 20.075;
specs = [T_u, T_o];         % technische Toleranzgrenzen
Tm = (T_u+T_o)/2;           % Toleranzmitte
T = T_o-T_u                 % technischer Toleranzbereich

sigma = T/8;                % angenommene Prozesssteuung   
C_p = T/(6*sigma)           % Berechneter C_p-Wert dazu

mu = Tm;                    % Prozesslage ideal
                            % Grafische Darstellung
p1 = normspec(specs,mu,sigma);
ausschuss1 = 100*(1-p1)     % Ausschuss in Prozent
title('');                  % deutsche Beschriftung
xlabel('Werte')
ylabel('Dichte der Normalverteilung')

                            % Illustration der Grenzen
yBereich = get(gca, 'YLim');
xBereich = [min(mu-6*sigma,T_u-0.01*T), max(mu+6*sigma,T_o+0.01*T)];
axis([xBereich(1), xBereich(2), yBereich(1), yBereich(2)])
h = line([T_u;T_u], yBereich);
set(h, 'Color','r');
text(T_u+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'T_u'); 
h = line([T_o;T_o], yBereich);
set(h, 'Color','r');
text(T_o+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'T_o'); 
h = line([Tm;Tm], yBereich);
set(h, 'Color','g');
text(Tm+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'Tm'); 


                            
mu = Tm+2*sigma;            % Prozesslage nicht ideal

                            % (normspec macht automatisch
                            % neues Grafikfenster auf)
                            % Grafische Darstellung
p2 = normspec(specs,mu,sigma);
ausschuss2 = 100*(1-p2)     % Ausschuss in Prozent

title('');                  % deutsche Beschriftung
xlabel('Werte')
ylabel('Dichte der Normalverteilung')

                            % Illustration der Grenzen
yBereich = get(gca, 'YLim');
%xBereich = [min(mu-6*sigma,T_u-0.01*T), max(mu+6*sigma,T_o+0.01*T)];
axis([xBereich(1), xBereich(2), yBereich(1), yBereich(2)])
h = line([T_u;T_u], yBereich);
set(h, 'Color','r');
text(T_u+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'T_u'); 
h = line([T_o;T_o], yBereich);
set(h, 'Color','r');
text(T_o+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'T_o'); 
h = line([Tm;Tm], yBereich);
set(h, 'Color','g');
text(Tm+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'Tm'); 
