function [fS] = DichteS(sigma, n)
%
% Funktion DichteS
%
% Aufruf: [fS] = DichteS(sigma, n)
%
% Diese Funktion berechnet die Dichte des Streuungs-Schtzers
% 
%    S = (1/(n-1))*sum_k^n( x_k - xquer )^2
%
% fr normalverteilte Daten mit Streuung sigma und stellt
% diese zusammen mit der Dichte der (approximierenden)
% Normalverteilung N(an*sigma, (1-an^2)*sigma^2)) 
% im Intervall [0, sigma*an+4*sqrt((1-an^2)*sigma^2)] grafisch dar.
%
% Eingangsdaten:	  sigma      Streuung der X_k
%
%                     n          Zahl der Stichprobenwerte
%
% Ausgangsdaten:	  fS         Werte der Dichte im Intervall 
%                                [0, sigma*an+4*sqrt((1-an^2)*sigma^2)]
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.2.2004


% Sttzstellen im Bereich [0, mu+4*sqrt((1-an^2)*sigma^2)]

an = sqrt(2/(n-1))*gamma(n/2)/gamma((n-1)/2);
mu = sigma*an;
sig = sqrt((1-an^2)*sigma^2);
s = (0:0.01:mu+4*sig);

% Berechnung der Dichte

faktor = sqrt((n-1)/n)*(n-1)^((n-1)/2)/(2^((n-3)/2)*...
                              gamma((n-1)/2)*sigma^(n-1));


fS = faktor*(s.^(n-2)).*exp(-(n-1)/(2*sigma^2)*s.^2);

% Berechnung der (approximierenden) Normalverteilung

y = normpdfB(s, mu, sig);

% Darstellung der Dichten

plot(s,fS,'b', s,y,'r-.', 'LineWidth',3);
axis([0, max(s), 0, max(max(fS),max(y))])


