function [ModW] = EmpModal(stprob, klmitten)
%
% Aufruf: [ModW] = EmpModal(stprob, klmitten)
%
% Berechnet den empirischen Modalwert einer Stichprobe. Die Berechnung beruht
% auf der Bestimmung der empirischen Verteilung fr die Stichprobe und hngt von der Wahl der
% Klassen ab, die durch den Vektor klmitten bestimmt werden.
%
% Eingabeparameter:    stprob       Stichprobe
%
%                      klmitten     Klassenmitten fr Berechnung der empirischen Verteilung
%
% Ausgabeparameter:    ModW         "empirischer" Modalwert
%
%
% Es werden sonst KEINE Fehleingaben abgefangen!!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 20.12.2003


% (Klassen-)Hufigkeitsverteilung berechnen
    
[Hfg, X, emdist, cemdist] = distempStetig(stprob, klmitten, 0);

% Modalwert berechnen

[mx, ind] = max(emdist);
ModW = X(ind);