function [Fval] = binocdfB(x,n,p)
%
% Funktion binocdfB
%
% Aufruf: [Fval] = binocdfB(x,n,p)
%
% Diese Funktion berechnet die kumulative Binomialverteilung mit 
% den Parametern und p.
% (vgl. Abschnitt 2.2.1)
% 
% Eingangsdaten:	  x          Werte, bei denen die kumulative Verteilung
%                                berechnet werden soll (muss ein Skalar oder
%                                ein Zeilen- oder Spaltenvektor sein)
%
%                     n          Anzahlparameter
%                     p          Wahrscheinlichkeitsparameter
%
% Ausgangsdaten:	  Fval       Wahrscheinlichkeit(en) P(X<=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 29.8.2004/12.9.2004

if sum(size(x)>1)>1 % x kein Skalar oder Vektor
    error('binopdfB gestattet nur skalare oder vektorielle Argumente. Abbruch!');
end

N = length(x);
Fval = NaN*ones(size(x));

for j = 1:N
    m = floor(x(j));       % nchstkleinerer ganzzahliger Wert

    if m<0
        Fval(j) = 0;
    else
        Fval(j) = 0;       % Vorinitialisierung
        for k=0:m          % Werte der Binomialverteilung akkumulieren.
            Fval(j) = Fval(j) + binopdfB(k,n,p);
        end
    end

    if Fval(j)>1
        Fval(j)=1;
    end
end


