function [Fval] = binopdfB(x,n,p)
%
% Funktion binopdfB
%
% Aufruf: [Fval] = binopdfB(x,n,p)
%
% Diese Funktion berechnet die Binomialverteilung mit 
% den Parametern n und p.
% (vgl. Abschnitt 2.2.1)
% 
% Eingangsdaten:	  x          GANZZAHLIGE Werte, bei denen die Verteilung
%                                berechnet werden soll (muss ein Skalar oder
%                                ein Zeilen- oder Spaltenvektor sein)
%
%                     n          Anzahlparameter
%                     p          Wahrscheinlichkeitsparameter
%
% Ausgangsdaten:	  Fval       Wahrscheinlichkeit(en) P(X=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 29.8.2004/12.9.2004

warning off         % fr Warnmeldungen von nchooosek

if sum(size(x)>1)>1 % x kein Skalar oder Vektor
    error('binopdfB gestattet nur skalare oder vektorielle Argumente. Abbruch!');
end

N = length(x);
Fval = NaN*ones(size(x));

for j = 1:N
    k = floor(x(j));    % nchstkleinerer ganzzahliger Wert
    if abs(x(j)-k)>eps  % kein ganzzahliger Wert
        Fval(j) = 0;
    elseif k < 0
        Fval(j) = 0;
    elseif k<=n
        Fval(j) = nchoosek(n,k)*p^k*(1-p)^(n-k);
    else
        Fval(j) = 0;
    end 
end


