function [p,CpWert, CpkWert] = capableB(daten, ttols)
%
% Funktion capableB
%
% Aufruf: [p,CpWert, CpkWert] = capableB(daten, ttols)
%
% Funktion zur Berechnung der Fhigkeitsindices
%
% 
% Eingangsdaten:	  daten      Vektor von NORMALVERTEILTEN (Mess)-Werten
%
%                     ttols      Intervall [Tu,To] mit der unteren und
%                                oberen technischen Toleranz
%
% Ausgangsdaten:	  p          Wahrscheinlichkeit, dass wie daten 
%                                NORMALVERTEILTE Werte innerhalb der 
%                                technischen Toleranzen liegen. Die Parameter
%                                mu und sigma der Normalverteilung werden
%                                dabei aus daten geschtzt.
% 
%                     Cp         Cp-Wert
%
%                     Cpk        Cpk-Wert
%
% Es werden i.W. keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.9.2004


if sum(size(daten)>[1,1])>=2   % daten kein Vektor
    error('capableB kann fr daten nur vektorielle Argumente verarbeiten. Abbruch!');
end

if sum(size(ttols))~=3         % Toleranzen kein 1x2- oder 2x1-Vektor
    error('Zweites Argument muss ein 1x2- oder 2x1-Vektor sein. Abbruch!');
end

% Schtzung der Parameter der Normalverteilung

mu = mean(daten);
sigma = std(daten);

% Cp- und Cpk-Wert berechnen

T_u = ttols(1); T_o = ttols(2); 
CpWert = (T_o-T_u)/(6*sigma);
Cpu = (mu-T_u)/(3*sigma);
Cpo = (T_o-mu)/(3*sigma);
CpkWert = min(Cpu,Cpo);

% Wahrscheinlichkeit p berechnen

p1 = normcdfB(T_u, mu, sigma);     % Wkt unterhalb von T_u
p2 = 1 - normcdfB(T_o, mu, sigma); % Wkt oberhalb von T_o

% Wkt auerhalb der technischen Toleranz

p = p1 + p2;