function [p,h] = capaplotB(daten, ttols)
%
% Funktion capaplotB
%
% Aufruf: [p,h] = capaplotB(daten, ttols)
%
% Diese Funktion plottet die Normalverteilung, die sich aus den aus
% daten geschtzten Parametern mu und sigma ergibt und kennzeichnet
% den Teil, der in die angegebenen technischen Toleranzen ttols fllt.
%
% p ist die Wahrscheinlichkeit, mit der ein Wert in das Intervall ttols
% fllt, h ist ein leerer Vektor, der aus Kompatibilittsgrnden mit
% der Toolbox-Funktion capaplot in der Liste der Rckgabeparameter erscheint.
%
% Eingangsdaten:	  daten      Vektor von NORMALVERTEILTEN (Mess)-Werten
%
%                     ttols      Intervall [Tu,To] mit der unteren und
%                                oberen technischen Toleranz
%
% Ausgangsdaten:	  p          Wahrscheinlichkeit, dass wie daten 
%                                NORMALVERTEILTE Werte innerhalb der 
%                                technischen Toleranzen liegen. Die Parameter
%                                mu und sigma der Normalverteilung werden
%                                dabei aus daten geschtzt.
%                     h          immer gleich []
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.9.2004


if sum(size(daten)>[1,1])>=2   % daten kein Vektor
    error('capableB kann fr daten nur vektorielle Argumente verarbeiten. Abbruch!');
end

if sum(size(ttols))~=3         % Toleranzen kein 1x2- oder 2x1-Vektor
    error('Zweites Argument muss ein 1x2- oder 2x1-Vektor sein. Abbruch!');
end

% Schtzung der Parameter der Normalverteilung

mu = mean(daten);
sigma = std(daten);


p = normcdfB(ttols(2),mu,sigma)-normcdfB(ttols(1),mu,sigma);
h = [];

% Plotgrenzen bestimmen

if ttols(1) ~= -Inf
    links = min(ttols(1),mu-4*sigma);
    a = ttols(1);
else
    links = mu-4*sigma;
    a = links;
end

if ttols(2) ~= Inf
    rechts = max(ttols(2),mu+4*sigma);
    b = ttols(2);
else
    rechts = mu+4*sigma;
    b = rechts;
end

dx = (rechts-links)/100;
x = (links:dx:rechts);
y = normpdfB(x,mu,sigma);

% Dichte plotten

plot(x, y, 'b-', 'LineWidth', 3);
xlabel('Mae');
ylabel('Dichte der Normalverteilung');
% title(['Wahrscheinlichkeit in den Grenzen ',num2str(p)]);
axis([links,rechts,0,1.03*max(y)])

% Flche ausfllen

x1 = (a:dx:b);
y1 = normpdfB(x1,mu,sigma);
x1 = [a, x1, b]; 
y1 = [0, y1, 0];
patch(x1,y1,'y');

