function [yWerte,xWerte,N] = cdfcalcB(daten)
%
% Funktion cdfcalcB
%
% Aufruf: [yWerte,xWerte,N] = cdfcalcB(daten)
%
% Diese Funktion berechnet die empirische Verteilungsfunktion fr
% die Daten aus daten. Dazu wird die bereits vorhandene Buch-Funktion
% distempDiskret verwendet. Die vorliegende Funktion passt distempDiskret 
% lediglich an das Verhalten der (undokumentierten) Statistics-Toolbox-Funktion
% cdfcalc an.
%
%
% Eingangsdaten:	  daten      Stichprobe (Vektor von Werten)
%
%
% Ausgangsdaten:	  yWerte     Werte der empirischen Verteilungsfunktion 
%
%                     xWerte     zugehrige Sprungstellen
%
%                     N          Zahl der Werte der Stichprobe daten
%
% Es werden i.W. keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.9.2004


if sum(size(daten)>[1,1])>=2   % daten kein Vektor
    error('cdfcalcB kann fr daten nur vektorielle Argumente verarbeiten. Abbruch!');
end

N = length(daten);

% Aufruf von distempDiskret 
[vals, emdist, cemdist] = distempDiskret(daten,0);
xWerte = vals(:);
yWerte = cemdist(:);
yWerte(end) = [];