function [wD] = chi2pdfB(x,n)
%
% Funktion chi2pdfB
%
% Aufruf: [wD] = chi2pdfB(x,n)
%
% Diese Funktion realisiert die Dichte der Chi-Quadrat-Verteilung mit 
% n Freiheitsgraden (vgl. Abschnitt 2.7.2)
%
%
% Eingangsdaten:	  x          Wert, bei dem die Dichte der chi^2-Verteilung
%                                berechnet werden soll
%
%                     n          Freiheitsgrad
%
% Ausgangsdaten:	  wD         Wert der Dichte bei x
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 29.8.2004


if n<1
    error('Der Freiheitsgrad muss eine Zahl > 0 sein. Abbruch!');
end

faktor = 1/((2^(n/2))*gamma(n/2));
wD = (x>0).*faktor.*x.^(n/2-1).*exp(-x/2);



