function [mw,var] = chi2statB(n)
%
% Funktion chi2statB
%
% Aufruf: [mw,var] = chi2statB(n)
%
% Diese Funktion bestimmt Mittelwert und Varianz der chi^2-Verteilung 
% mit n Freiheitsgraden.
%
%
% Eingangsdaten:	  n          Freiheitsgrad
%
% Ausgangsdaten:	  mw         Erwartungswert
%                     var        Varianz
%
% Es werden keine Fehleingaben abgefangen! 
%                                  
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004


if sum(size(n)~=[1,1])~=0    % kein Skalar
    error('chi2statB gestattet keine vektoriellen Argumente. Abbruch!');
end

if n<=0
    error('Der Freiheitsgrad muss positiv sein. Abbruch!');
end 

mw = n; var = 2*n;