function [arg] = expinvB(p,T)
%
% Funktion expinvB
%
% Aufruf: [arg] = expinvB(p,T)
%
% Diese Funktion realisiert die INVERSE Exponentialverteilung mit 
% (Zeit-)Parameter T (vgl. Abschnitt 2.5.5)
%
%
% Eingangsdaten:	  p          Wahrscheinlichkeit, fr die das einseitige
%                                Quantil arg mit P(X<=arg)=p gesucht werden soll
%
%                     T          Zeitparameter T = 1/lambda
%
% Ausgangsdaten:	  arg        Argument
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004


if sum(size(p)~=[1,1])~=0     % p kein Skalar
    error('expinvB gestattet keine vektoriellen Argumente. Abbruch!');
end

if T<=eps
    error('Der Zeitparameter T muss eine Zahl > 0 sein. Abbruch!');
end

arg = -T*log(1-p);