function [zZahl] = exprndB(T)
%
% Funktion exprndB
%
% Aufruf: [zZahl] = exprndB(T)
%
% Diese Funktion erzeugt EINE Zufallszahl. Die erzeugten Zufalls-
% zahlen gengen einer Exponentialverteilung mit 
% (Zeit-)Parameter T (man vergleiche die Funktion getExpVar
% der Begleitsoftware).
%
%
% Eingangsdaten:	  T          Zeitparameter T = 1/lambda
%
% Ausgangsdaten:	  zZahl      erzeugte Zufallszahl
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004


if T<=eps
    error('Der Zeitparameter T muss eine Zahl > 0 sein. Abbruch!');
end
                                 % (Gleichverteilten) Zufallspunkt im Intervall 
                                 % [0,1] bestimmen
x = rand(1,1);
                                 % Transformationsformel anwenden
zZahl = -T*log(1-x);
 
