function [p] = fcdfB(x,m,n)
%
% Funktion fcdfB
%
% Aufruf: [p] = fcdfB(x,m,n)
%
% Diese Funktion realisiert die kumulative F-Verteilung mit m,n Freiheitsgraden
% (vgl. Abschnitt 2.7.2)
% Der Wert wird durch numerische Integration von fpdfB im Intervall
% [0,x] bis auf 4 Nachkommastellen genau bestimmt.
%
%
% Eingangsdaten:	  x          Wert, bei dem die kumulative F-Verteilung
%                                berechnet werden soll (muss ein Skalar sein)
%
%                     m          1. Freiheitsgrad
%                     n          1. Freiheitsgrad
%
% Ausgangsdaten:	  p          Wahrscheinlichkeit P(X<=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 15.9.2004

if sum(size(x)~=[1,1])~=0     % x kein Skalar
    error('fcdfB gestattet keine vektoriellen Argumente. Abbruch!');
end

if n<1 | m<1 | abs(floor(n)-n)>eps | abs(floor(m)-m)>eps      
    error('Freiheitsgrade mssen natrliche Zahlen sein. Abbruch!');
end


% Die Verteilungsfunktion der F-Verteilung kann durch die Substitution
% 
%  t = -(n/m)*u*(1/(u-1))
%
% auf die unvollstndige BETA-Funktion zurckgefhrt werden.
% Diese Funktion nist Bestandteil von MATLAB!

if x<0
    p = 0;
else
    % Integrationsgrenze festlegen
    y = x/(x+n/m);
    % Unvollstndige Beta-Funktion aufrufen
    p = betainc(y,m/2,n/2);
end

