function [pWert,AnovTab,TestStat] = friedmanB(X)
%
% Funktion friedmanB
%
% Aufruf: [pWert,AnovTab,TestStat] = friedmanB(X)
%
% Diese Funktion realisiert einen FRIEDMAN-TEST fr einen BALANCIERTEN 
% VERSUCHSPLAN nach Art der STATISTICS-TOOLBOX-Funktion friedman.
%
% Die Funktion hat im Wesentlichen die gleiche Aufrufschnittstelle
% wie friedman und kann als ERSATZFUNKTION eingesetzt werden.
% Die Funktion hat gegenber friedman EINGESCHRNKTE FUNKTIONALITT,
% da nur Tableaus mit EINFACHER BESETZUNG zugelassen sind.
% Insbesondere erfolgt keine grafische Ergebnisausgabe, wie bei friedman.
% Ferner werden die Bindungen anders behandelt als bei friedman. Es wird
% ein Korrekturfaktor aus [30] verwendet.
%
% Eingangsdaten:	  X          Matrix der Daten
%                                Bei der MATRIX wird von einem BALANCIERTEN
%                                Versuchsplan MIT EINFACHER BESETZUNG
%                                ausgegangen. Die Daten sind 
%                                SPALTENWEISE organisiert.
%
% Ausgangsdaten:	  pWerte     die p-Werte
%                                  
%                     AnovTab    Cell-Array mit der ANOVA-Tabelle 
%    
%                     TestStat   Struktur mit der Teststatistik
%
% Es werden nur wenige Fehleingaben abgefangen! 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 6.9.2004

[m,k] = size(X);

if k<2 | m<2                 % X zu klein
    error('Matrix X muss mindestens 2 Zeilen und 2 Spalten haben. Abbruch!');
end

if k<5 | m<5                 % X zu klein
    warning('Matrix X ist sehr klein. Eventuell keine gute Approximation durch die Chi^2-Quantile!');
end

% Teststatistik initialisieren

TestStat.WerteProSpaltenfaktor = m;
TestStat.RangsummenMittelSpalte = [];

% Spaltenrnge bestimmen

Rnge = []; bndKorrF = 0;
for j = 1:m
    [rnk, bndg] = getrnk(X(j,:));
    Rnge = [Rnge; rnk];
    bndKorrF = bndKorrF + sum(bndg.^3-bndg);
end

% ANOVA-Tabelle vorinitialisieren

AnovaTab = cell(6,4);
[p0,AnovTabV] = anova2B(Rnge);
AnovTab{1,1} = AnovTabV{1,1}; AnovTab{1,2} = AnovTabV{1,2};
AnovTab{1,3} = AnovTabV{1,3}; AnovTab{1,4} = AnovTabV{1,4};
AnovTab{2,1} = AnovTabV{2,1}; AnovTab{3,1} = AnovTabV{5,1};
AnovTab{4,1} = AnovTabV{6,1};
AnovTab{2,2} = AnovTabV{2,2}; AnovTab{3,2} = AnovTabV{5,2};
AnovTab{4,2} = AnovTabV{6,2};
AnovTab{2,4} = AnovTabV{2,4}; AnovTab{3,4} = AnovTabV{5,4};
AnovTab{4,4} = AnovTabV{6,4};
AnovTab{1,5} = 'ChiQ'; AnovTab{1,6} = 'Prob>ChiQ';
AnovTab{2,3} = k-1; AnovTab{3,3} = (m-1)*(k-1); AnovTab{4,3} = m*k-1;

% Korrekturfaktor fr Bindungen (nach Victor)

if bndKorrF~=0
    bndKorrF = m/(m-(1/(k^3-k))*bndKorrF);
else
    bndKorrF = 1;
end

% Rangsummen der Spalten berechen

Ri = sum(Rnge);
TestStat.RangsummenMittelSpalte = Ri/m;

% Wert der Testvariablen berechnen

faktor = 12/(k*(k+1)*m);
mtl = (m/2)*(k+1);
T = bndKorrF*faktor*sum((Ri-mtl).^2);
AnovTab{2,5} = T;


pWert = 1-chi2cdfB(T,k-1);
AnovTab{2,6} = pWert;

