function [Fval] = geocdfB(x,p)
%
% Funktion geocdfB
%
% Aufruf: [Fval] = geocdfB(x,p)
%
% Diese Funktion berechnet die kumulative Geometrische Verteilung mit 
% dem Parameter p.
% (vgl. Abschnitt 2.5.3)
% 
% Eingangsdaten:	  x          Werte, bei denen die Verteilung
%                                berechnet werden soll (muss ein Skalar oder
%                                ein Zeilen- oder Spaltenvektor sein)
%
%                     p          Wahrscheinlichkeitsparameter
%
% Ausgangsdaten:	  Fval       Wahrscheinlichkeit(en) P(X<=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 31.8.2004/12.9.2004


if sum(size(x)>1)>1 % x kein Skalar oder Vektor
    error('binopdfB gestattet nur skalare oder vektorielle Argumente. Abbruch!');
end

N = length(x);
Fval = NaN*ones(size(x));

for j = 1:N
    m = floor(x(j));       % nchstkleinerer ganzzahliger Wert

    if m<0
        Fval(j) = 0;
    else
        Fval(j) = 0;       % Vorinitialisierung
        for k=0:m       % Werte der Binomialverteilung akkumulieren.
            Fval(j) = Fval(j) + geopdfB(k,p);
        end
    end

    if Fval(j)>1
        Fval(j)=1;
    end
end

