function [Qval] = geoinvB(x,p)
%
% Funktion geoinvB
%
% Aufruf: [Qval] = geoinvB(x,p)
%
% Diese Funktion berechnet die Quantile der Geometrischen-Verteilung mit 
% Parameter p.
% (vgl. Abschnitt 2.7.1)
% 
% Eingangsdaten:	  x          vorgegebene Wahrscheinlichkeit
%
%                     p          Parameter der Poisson-Verteilung (Mittelwert)
%
% Ausgangsdaten:	  Qval       GANZZAHLIGER Wert mit P(X <= Qval) = x
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 14.9.2004


if sum(size(x)>1)~=0 | sum(size(p)>1)~=0% kein Skalar
    error('geoinvB gestattet nur skalare Argumente. Abbruch!');
end

Qval = 0;

while geocdfB(Qval,p)<x
    Qval = Qval+1;
end