function [Fval] = geopdfB(x,p)
%
% Funktion geopdfB
%
% Aufruf: [Fval] = geopdfB(x,p)
%
% Diese Funktion berechnet die Geometrische Verteilung mit 
% dem Parameter p.
% (vgl. Abschnitt 2.5.3)
% 
% Eingangsdaten:	  x          GANZZAHLIGE Werte, bei denen die Verteilung
%                                berechnet werden soll (muss ein Skalar oder
%                                ein Zeilen- oder Spaltenvektor sein)
%
%                     p          Wahrscheinlichkeitsparameter
%
% Ausgangsdaten:	  Fval       Wahrscheinlichkeit P(X=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 31.8.2004/13.9.2004

if sum(size(x)>1)>1 % x kein Skalar oder Vektor
    error('binopdfB gestattet nur skalare oder vektorielle Argumente. Abbruch!');
end

N = length(x);
Fval = NaN*ones(size(x));

for j = 1:N
    k = floor(x(j));       % nchstkleinerer ganzzahliger Wert
    if abs(x(j)-k)>eps     % kein ganzzahliger Wert
        Fval(j) = 0;
    elseif k < 0
        Fval(j) = 0;
    else
        Fval(j) = p*(1-p)^k;
    end
end
   


