function [mw,var] = geostatB(p)
%
% Funktion geostatB
%
% Aufruf: [mw,var] = geostatB(p)
%
% Diese Funktion bestimmt Mittelwert und Varianz der  geometrischen
% Verteilung mit Parameter p.
%
%
% Eingangsdaten:	  p          Wahrscheinlichkeitsparameter
%
% Ausgangsdaten:	  mw         Erwartungswert
%                     var        Varianz
%
% Es werden keine Fehleingaben abgefangen! 
%                                  
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 14.9.2004


if sum(size(p)~=[1,1])~=0     % p kein Skalar
    error('geostatB gestattet keine vektoriellen Argumente. Abbruch!');
end

if p<0 | p>1
    error('p muss eine Wahrscheinlichkeit sein. Abbruch!');
end 

mw = (1-p)/p; var = (1-p)/(p*p);