function [rnk, bndg] = getrnk(vector)
% 
% Funktion getrnk
%
% Aufruf: [rnk, bndg] = getrnk(vector)
%
% Funktion zur Bestimmung der RNGE eines Vektors vector unter
% Bercksichtigung von Bindungen.
%
% Eingangsdaten:	  vector     Vektor von Daten                    
%
% Ausgangsdaten:	  rnk        Vektor der zugeordneten Rnge
%                                  
%                     bndg       Vektor mit Zahl der Bindungen (falls vorhanden) 
%    
% Es werden keine Fehleingaben abgefangen! 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.9.2004

M = length(vector);
rnk = zeros(size(vector)); bndg = [];
rnge = cumsum(ones(1,M));

[y,indx] = sort(vector);
%rnk(indx) = rnge;

z = abs(diff(y))>eps;
z = z(:)';
stelle = [0, diff(z)]; N = length(stelle);

bindgneu = 1; up = 1;
for k=1:N
   if stelle(k)==-1 & k<N
       bindgneu = k; up = 0;
   elseif stelle(k)==1 
       bndg = [bndg, k-bindgneu+1];
       mtlr = mean(rnge(bindgneu:k));
       rnge(bindgneu:k) = mtlr;
       up = 1;
   elseif stelle(k)==-1 & k==N
       bndg = [bndg, 2];
       mtlr = mean(rnge(N:N+1));
       rnge(N:N+1) = mtlr;
   end   
end

if stelle(N)==0 & ~up
    bndg = [bndg, N-bindgneu+2];
    mtlr = mean(rnge(bindgneu:N+1));
    rnge(bindgneu:N+1) = mtlr;
end

rnk(indx) = rnge;