function [hmW] = harmmeanB(daten)
%
% Funktion cdfcalcB
%
% Aufruf: [hmW] = harmmeanB(daten)
%
% Diese Funktion berechnet das HARMONISCHE MITTEL der Werte in daten.
%
%
% Eingangsdaten:	  daten      Stichprobe (Vektor von Werten)
%
%
% Ausgangsdaten:	  hmW        harmonisches Mittel
%
% Es werden i.W. keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.9.2004


if sum(size(daten)>[1,1])>=2   % daten kein Vektor
    error('harmmeanB kann fr daten nur vektorielle Argumente verarbeiten. Abbruch!');
end

if ~all(daten)                 % es gibt Werte =0
    error('daten enthlt Werte gleich 0. Abbruch!');
end

hmW = 1/mean(1./daten);