function [] = histfitB(daten,binzahl)
%
% Funktion histfitB
%
% Aufruf: [] = histfitB(daten,binzahl)
%
% Diese Funktion plottet ein Histogramm der NORMALVERTEILTEN Daten
% im Vektor daten und passt eine Normalverteilungtsdichte daran an
% (vgl. dazu auch die Datei uebungHisto2.m der Begleitsoftware).
%
% Die Funktion hat gegenber der Statistics-Toolbox-Funktion eingeschrnkte
% Funktionalitt, da sie nicht die handles auf die Grafikobjekte zurck-
% liefert. Ein weiterer Unterschied ist, dass die Balkenhhen des Histogramms
% an die theoretische Dichte angepasst werden und nicht umgekehrt wie bei
% histfit.
%
% Eingangsdaten:	  daten      Stichprobe (Vektor von Werten)
%
%                     binzahl    Zahl der Klassen (Diagrammbalken)
%                                Ist der Parameter nicht angegeben,
%                                wird stets die Wurzel aus dem
%                                Stichprobenumfang verwendet, minimal aber
%                                5 und maximal 30.
%
% Ausgangsdaten:	 keine
%
% Es werden i.W. keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 5.9.2004

nargs = nargin;

if nargs == 1            % Default: binzahl wird berechnet
    binzahl = min(max(5,ceil(sqrt(length(daten)))),30);
end

if sum(size(daten)>[1,1])>=2   % daten kein Vektor
    error('histfitB kann fr daten nur vektorielle Argumente verarbeiten. Abbruch!');
end

% Schtzung der Parameter der Normalverteilung

mu = mean(daten);
sigma = std(daten);

% bins bestimmen

intv = max(daten)-min(daten);     % Range der Daten
deltabin = intv/binzahl;          % Abstand der bins
bins = (min(daten)+deltabin/2:deltabin:max(daten)-deltabin/2);

% Absolute Klassenhufigkeiten mit hist bestimmen

[anz, x] = hist(daten, bins);

% Relative Klassenhufigkeiten

relH = anz/length(daten);


% Histogramm und Dichte der Normalverteilung anpassen

bar(x, relH/deltabin, 0.8);
hold
ug = min(min(daten)-deltabin/2,mu-4*sigma);
og = max(max(daten)+deltabin/2,mu+4*sigma);
dx = (og-ug)/100;
vals =(ug:dx:og);
plot(vals, normpdfB(vals,mu,sigma), 'r-', 'LineWidth',4);
axis([ug,og,0,1.2*max(max(relH),max(normpdfB(vals,mu,sigma)))])
xlabel('Klassen; Breite dx')
ylabel('rel.Hfgk./dx; Dichte')