function [pWert,AnovTab,TestStat] = kruskalwallisB(X,varargin)
% 
% Funktion kruskalwallisB
%
% Aufruf: [pWert,AnovTab,TestStat] = kruskalwallisB(X)
%
% Diese Funktion realisiert einen KRUSKAL-WALLIS-TEST
% nach Art der STATISTICS-TOOLBOX-Funktion kruskalwallis.
%
% Die Funktion hat im Wesentlichen die gleiche Aufrufschnittstelle
% wie anova1 und kann als ERSATZFUNKTION eingesetzt werden.
% Die Funktion hat gegenber anova1 EINGESCHRNKTE FUNKTIONALITT.
% Insbesondere erfolgt keine grafische Ergebnisausgabe, wie bei kruskalwallis.
% Ferner beschrnkt sich diese Funktion auf einen BALANCIERTEN
% Versuchsplan. Die Einflussfaktoren sind in den Spalten der Matrix X
% organisiert.
%
% Eingangsdaten:	  X          Matrix der Daten
%                                Es wird von einem BALANCIERTEN
%                                Versuchsplan ausgegangen. Die Daten sind 
%                                SPALTENWEISE organisiert.                         
%
% Ausgangsdaten:	  pWert      der p-Wert
%                                  
%                     AnovTab    Cell-Array mit der ANOVA-Tabelle 
%    
%                     TestStat   Struktur mit der Teststatistik
%
%
% Es werden nur wenige Fehleingaben abgefangen! 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 6.9.2004


nargs = nargin;

if nargs > 1       
      error('Die Datenmatrix X ist das einzige Argument von kruskalwallisB. Abbruch!');  
end

% Dimension der Tabelle feststellen

DimX = size(X);

if DimX(2)<2
    error('Die Datenmatrix X muss mindestens zwei Spalten haben! Abbruch!')
end

if DimX(2)<4 | DimX(1)<5
    warning('Die Datenmatrix X ist sehr klein. Keine gute Nherung durch die Chi-Quadrat-Verteilung!')
end

% Tabelle zu einer Spalte ordnen, Rnge und Bindungen
% berechne

X = X(:); n = length(X);
[rnkX, bndgX] = getrnk(X);

% Rnge entsprechend der ursprnglichen Anordnung
% von X sortieren

rangMat = reshape(rnkX, DimX);

% Rangsummen der Spalten berechnen und mit der Anzahl
% der Werte in jeder Spalte multiplizieren

rgSumMittel = sum(rangMat)/DimX(1);

% Testgre berechnen

Ttilde = sum(DimX(1)*(rgSumMittel - (n+1)/2).^2);

% Korrekturfaktor fr Bindungen einbeziehen

if ~isempty(bndgX)
    fkt = 1 - (1/(n^3-n))*sum(bndgX.^3-bndgX);
else
    fkt = 1;
end

fkt2 = 12/(n*(n+1));

T = (1/fkt)*fkt2*Ttilde;     % Testvariable

% anova1b mit der Rangmatrix aufrufen, um ANOVA-Tabelle zu erzeugen

[p,AnovTab,TstS] = anova1B(rangMat);

% Teststatistik und p-Wert eintragen

AnovTab{1,5} = 'Chi-Q'; AnovTab{1,6} = 'Prob>Chi-Q';
AnovTab{2,5} = T; pWert = 1 - chi2cdfb(T, DimX(2)-1);
AnovTab{2,6} = pWert;

TestStat.n = DimX(1)*ones(1,DimX(2));
TestStat.MittelRaenge = mean(rangMat);





