function [Ent, pWert, TstStat, CritVal] = kstestB(x,Dichte,alpha,altHyp)
%
% Funktion kstestB
%
% Aufruf: [TstStat] = kstestB(x,Dichte,alpha,altHyp)
%
% Diese Funktion realisiert einen KOLMOGOROV-SMIRNOV-TEST 
% nach Art der STATISTICS-TOOLBOX-Funktion kstest.
%
% Die Funktion hat im Wesentlichen die gleiche Aufrufschnittstelle
% wie kstest und kann als ERSATZFUNKTION eingesetzt werden.
% Im Gegensatz zu kstest wird das Testergebnis in Form der Struktur
% TestErgebnis zurckgeliefert. Die Funktion hat gegenber der
% Statistics-Toolbox-Funktion ranksum EINGESCHRNKTE FUNKTIONALITT.
% Es kann lediglich ein ZWEISEITIGER TEST durchgefhrt werden.
% (vgl. Abschnitt 5.4.3)
%
% Eingangsdaten:	  x              Stichprobe
%
%                     Dichte         Matrix mit x-,y-Werten der Dichtefunktion
%                                    (Zwei Spalten!!!)
%
%                     alpha          Signifikanzniveau
%                                    (default = 0.05)
%
%                     altHyp         Art des Tests (stets 0 = zweiseitig),
%
% Ausgangsdaten:	  Ent            Testentscheidung (0=keine Ablehnung, 1=Ablehnung)
%
%                     pWert          p-Wert
%
%                     TstStat        Struktur mit dem Testergebnis
%
%                     CritVal        Kritischer Wert der Testvariablen
%
% Es werden i.W. keine Fehleingaben abgefangen! 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 6.9.2004/13.9.2004

nargs = nargin;
warning on

if sum(size(x)>[1,1])>=2  % x-daten kein Vektor
    error('kstestB kann vektorielle Argumente verarbeiten. Abbruch!');
end

if nargs <= 2            % Defaultfall 1
    alpha = 0.05; altHyp = 0;
elseif nargs == 3        % Defaultfall 2
    altHyp = 0;
elseif nargs == 4  
    altHyp = 0;
    warning('Es ist nur ein zweiseitiger Test mglich!');
else
      error('Aufrufstruktur von kstestB beachten. Abbruch!');  
end

% Dichte 
if ~isempty(Dichte)
    [cdfx, indx] = sort(Dichte(:,1)); 
    cdfy = Dichte(indx,2);
else                     % Defaultfall 3
    cdfx = sort(x); cdfy = normcdfB(cdfx);  % Standard-Normalverteilung
end

n = length(x);

if n<50
    warning('Stichprobenlnge < 50. kstestB u.U.nicht sehr genau!')
end


% Dichtedefinition prfen

istgleich = find(diff(cdfx) == 0);  % gleiche x-Werte
cdfx(istgleich) = [];               % und entsprechende y-Werte
cdfy(istgleich) = [];               % eliminieren


% Empirische kumulative Verteilungsfunktion bestimmen

[yWerte,xWerte,N] = cdfcalcB(x);

% Theoretische Verteilungsfunktionswerte bestimmen

yWerteCDF = interp1(cdfx,cdfy,xWerte);


% TstStat treffen

TstStat.Testart = 'Kolmogorov-Smirnov-Test zweiseitig';
TstStat.Testniveau = alpha;

% Testvariable bestimmen

Dn = max([max(abs(yWerteCDF-yWerte(1:end-1))),max(abs(yWerteCDF-yWerte(2:end)))]); 
TstStat.pWert = 1-kolmcdfB(sqrt(n)*Dn);
pWert = TstStat.pWert;


TstStat.TestStatistik = Dn;
TstStat.SchwellwertC = kolminvB(1-alpha)/sqrt(n);
Ent = TstStat.pWert < alpha; 
CritVal = TstStat.SchwellwertC;


if Ent
     TstStat.Testentscheidung = 'Die Nullhypothese wird abgelehnt!';
else
     TstStat.Testentscheidung = 'Die Nullhypothese wird nicht abgelehnt!';
end