function [zMoment] = momentB(daten, ordnung)
%
% Funktion momentB
%
% Aufruf: [zMoment] = momentB(daten, ordnung)
%
% Diese Funktion bestimmt die ZENTRALEN Momente der ORDNUNG ordnung
% fr die Stichprobe aus Daten.
%
% Eingangsdaten:	  daten      Stichprobe (Vektor von Werten)
%
%                     ordnung    natrliche Zahl
%
% Ausgangsdaten:	  zMoment    berechnetes zentrales Moment
%
% Es werden i.W. keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 5.9.2004

nargs = nargin;

if nargs ~= 2      
    error('momentB bentigt zwei Eingabeparameter. Abbruch!');
end

if sum(size(daten)>[1,1])>=2   % daten kein Vektor
    error('momentB kann fr daten nur vektorielle Argumente verarbeiten. Abbruch!');
end

if abs(ordnung-floor(ordnung))>=eps | ordnung<1   % ordnung keine natrliche Zahl
    error('Parameter ordnung muss eine natrlich Zahl sein. Abbruch!');
end

if ordnung < 2
    zMoment = 0;
else
    zMoment = sum( (daten-mean(daten)).^ordnung )/length(daten);
end;
