function [gradfx0] = mygradf(funkt,x0,varargin)               
%
% Funktion mygradf  
%
% Aufruf: [gradfx0] = mygradf(funkt,x0,P1,P2,...) 
%
% Numerische Berechnung des Gradienten der Funktion funkt an der
% Stelle x0.
%
% Eingangsdaten:	  funkt      handle auf eine MATLAB-Funktion, in der
%                                das Skalarfeld definiert ist, fr das der
%                                Gradient berechnet werden soll.
%
%                     x0         Stelle, an der der Gradient berechnet
%                                werden soll
%
%                     varargin   fr Parameter, die an funkt bergeben werden
%                                sollen
%
% Ausgangsdaten:	  gradfx0    Gradient an der Stelle x0
%
% Es werden keine Fehleingaben abgefangen! 
%                                  
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 8.9.2004

if sum(size(x0)>[1,1])>2    % x0 kein Vektor
    error('Parameter x0 von mygradf muss ein Vektor sein. Abbruch!');
end

x0 = x0(:)';                % x0 ein Zeilenvektor
N = length(x0);
gradfx0 = NaN*ones(size(x0));

for k=1:N                   % alle Komponenten durchlaufen
    h = 1/8;                % Anfangsschrittweite fr die Differenzen
                            % erste Nherung von df/dxk berechnen
    ek = zeros(1,N); ek(k)=1;                        
    ym2 = feval(funkt,x0-2*h*ek,varargin{:});
    ym1 = feval(funkt,x0-h*ek,varargin{:});
    y1 = feval(funkt,x0+h*ek,varargin{:});
    y2 = feval(funkt,x0+2*h*ek,varargin{:});
                            % Stummel/Hainer S.66
    dfxk = (-y2+8*y1-8*ym1+ym2)/(12*h);
    dfxkOK = 0; zaehler = 1;
    
    while ~dfxkOK
            h = h/2;        % Nchste Schrittweite fr die Differenzen
                            % Nherung von df/dxk berechnen
            ym2 = feval(funkt,x0-2*h*ek,varargin{:});
            ym1 = feval(funkt,x0-h*ek,varargin{:});
            y1 = feval(funkt,x0+h*ek,varargin{:});
            y2 = feval(funkt,x0+2*h*ek,varargin{:});
                            % Stummel/Hainer S.66
            dfxkAnfnext = (-y2+8*y1-8*ym1+ym2)/(12*h);
            zaehler = zaehler + 1;
            
            if zaehler > 20
                warning('Hchstiterationszahl 20 bei Gradientenberechnung berschritten!');
                dfxkOK = 1;
            end
            
            if abs(dfxkAnfnext-dfxk) < 0.00001
                dfxkOK = 1; 
            end
            
            dfxk = dfxkAnfnext;
    end
    
    gradfx0(k) = dfxk;
end