function [Fval] = nbinpdfB(x,k,p)
%
% Funktion nbinpdfB
%
% Aufruf: [Fval] = nbinpdfB(x,k,p)
%
% Diese Funktion berechnet die negative Binomialverteilung 
% (PASCAL-Verteilung) mit den Parametern k und p.
% (vgl. Abschnitt 2.2.1)
% 
% Eingangsdaten:	  x          GANZZAHLIGE Werte, bei denen die Verteilung
%                                berechnet werden soll (muss ein Skalar oder
%                                ein Zeilen- oder Spaltenvektor sein)
%
%                     k          Anzahlparameter
%                     p          Wahrscheinlichkeitsparameter
%
% Ausgangsdaten:	  Fval       Wahrscheinlichkeit P(X=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 31.8.2004/14.9.2004

if sum(size(x)>1)>1 % x kein Skalar oder Vektor
    error('binopdfB gestattet nur skalare oder vektorielle Argumente. Abbruch!');
end

N = length(x);
Fval = NaN*ones(size(x));

for m = 1:N
    j = floor(x(m));    % nchstkleinerer ganzzahliger Wert
    if abs(x(m)-j)>eps  % kein ganzzahliger Wert
        Fval(m) = 0;
    elseif j < 0
        Fval(m) = 0;
    else
        Fval(m) = nchoosek(k+j-1,j)*p^k*(1-p)^j;
    end  
end


