function [beta, resid, varargout] = nlinfitB(X,y,funkt,betaAnf,varargin)
% 
% Funktion nlinfitB
%
% Aufruf: [beta, resid, varargout] = nlinfitB(X,y,funkt,betaAnf, P1, P2,...)
%
% Diese Funktion schtzt die Koeffizienten der nichtlinearen Funktion
% funkt, um die Werte von funkt(X,beta) optimal an die Werte y anzupassen.
%
% Die Funktion hat im Wesentlichen die gleiche Aufrufschnittstelle
% wie nlinfit und kann als ERSATZFUNKTION eingesetzt werden.
% Die Funktion hat gegenber nlinfit EINGESCHRNKTE FUNKTIONALITT.
%
% Intern wird die im normalen MATLAB-Umfang enthaltene Funktion 
% fminsearch verwendet!
%
% Eingangsdaten:	  X          nxr-Matrix der unabhngigen Variablen
%
%                     y          nx1- bzw. 1xn-Vektor der Werte von funkt
%
%                     funkt      handle auf die MATLAB-Funktion, die
%                                die Funktionsvorschrift enthlt
%                                Syntax funkt(X,beta,varargin)
%
%                     betaAnf    Startwert fr die Iteration
%
%                     varargin   Werte die noch an funkt bergeben werden 
%                                knnen
%
% Ausgangsdaten:	  beta       geschtzte Koeffizienten
%
%                     resid      ydach - y = y - funkt(X,beta,varargin)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.9.2004

inargs = nargin;

if inargs < 4
    error('nlinfitB bentigt mindestens vier Argumente. Abbruch!');
end

[n,r] = size(X); 
if n==1      % Zeilenvektor zulassen
    X = X';  % Spaltenvektor daraus machen
    n = r; r = 1;
end
y = y(:); m = length(y);

if m~=n     
    error('X muss soviel Zeilen haben, wie y Komponenten hat. Abbruch!');
end

% Globale Variable fr Kommunikation mit der subfunction 
global nlinfitBfuncHandle

nlinfitBfuncHandle = funkt;

% Minimum des quadratischen Fehlers suchen

OPTIONS = optimset(@fminsearch);  % Optionen der Minimierung mit fminsearch sichern

% neue Optionen setzen und lesen

newopts = optimset(OPTIONS, 'Display', 'off', 'MaxIter', 5000, ...
                            'MaxFunEvals',2000*length(betaAnf));
%newopts = optimset(OPTIONS, 'TolX', 1.0000e-006, 'TolFun', 1.0000e-006);

[minimum] = fminsearch(@funcmini,betaAnf,[],X,y,varargin{:});

beta = minimum(:);  resid = [];
for k = 1:m
    xk = X(k,:);
    dyk = y(k) - feval(nlinfitBfuncHandle, beta, xk, varargin{:});
    resid = [resid;dyk];
end

if nargout>2
    for k=3:nargout
        varargout{k} = {[]};
    end
end





% Subfunctions:
%----------------------------------------------------------------------------------------
% Lokale Funktion, die die Aufgabe hat, aus dem Parameteranpassungsproblem
% fr func ein quadratisches Minimierungsproblem zu machen

function [QFehler] = funcmini(betaAktuell,X,y,varargin)

% die Funktion func wird als globale Variable bergeben

global nlinfitBfuncHandle 

% Auswertung der Quadratischen Fehlerfunktion

N = length(y);
QFehler = 0;

for k = 1:N
    xk = X(k,:);
    dyk = y(k) - feval(nlinfitBfuncHandle, betaAktuell, xk, varargin{:});
    QFehler = QFehler + dyk^2;
end