function [zZahl] = normrndB(mu,sigma,N,M)
%
% Funktion normrndB
%
% Aufruf: [zZahl] = normrndB(mu,sigma,N,M)
%
% Diese Funktion erzeugt Zufallszahlen. Die erzeugten Zufalls-
% zahlen gengen einer Normalverteilung mit 
% den Parametern mu und sigma.
%
%
% Eingangsdaten:	  mu         1. Parameter (Mittelwert)
%                     sigma      2. Parameter (Streuung)
%                     N,M        Dimension der Zufallszahlenmatrix
%
% Ausgangsdaten:	  zZahl      erzeugte Zufallszahl
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 31.8.2004/13.9.2004


nargs = nargin;

if nargs == 0            % Default: Standard-Normalverteilung, eine Zahl
    mu = 0; sigma = 1; N = 1; M = 1;
elseif nargs == 2        % Default:eine Zahl
    N = 1; M = 1;
elseif nargs == 1 | nargs == 3 | nargs>4
    error('Aufrufkonvention von normrndB beachten. Abbruch!');  
end

if sigma<=eps   
    error('Der Parameter sigma muss eine Zahl > 0 sein. Abbruch!');  
end

                                 % (Gleichverteilten) Zufallspunkt im Intervall 
                                 % [0,1] bestimmen
x = rand(N,M);
for k=1:N
    for m=1:M
                                       % Transformationsformel anwenden
        zZahl(k,m) = norminvB(x(k,m),mu,sigma);
    end
end
 
