function [mw,var] = normstatB(mu,sigma)
%
% Funktion normstatB
%
% Aufruf: [mw,var] = normstatB(mu,sigma)
%
% Diese Funktion bestimmt Mittelwert und Varianz der Normalverteilung 
% mit den Parametern mu und sigma
%
%
% Eingangsdaten:      mu         1. Parameter (Mittelwert)
%                     sigma      2. Parameter (Streuung)
%
% Ausgangsdaten:	  mw         Erwartungswert
%                     var        Varianz
%
% Es werden keine Fehleingaben abgefangen! 
%                                  
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004

nargs = nargin;

if nargs == 0            % Default: Standard-Normalverteilung
    mu = 0; sigma = 1;
end

if sigma<=eps
    error('Der Parameter sigma muss eine Zahl > 0 sein. Abbruch!');
end

mw = mu; var = sigma^2;