function [prctl] = prctileB(daten,prozent)
%
% Funktion prctileB
%
% Aufruf: [prctl] = prctileB(daten,prozent)
%
% Diese Funktion berechnet fr die Daten im Vektor daten denjenigen Wert prctl,
% fr den prozent Prozent der Werte kleiner sind als dieser Wert.
%
% Die Funktion hat gegenber der Statistics-Toolbox-Funktion eingeschrnkte
% Funktionalitt, da sie vektorielle Eingabeparameter fr prozent nicht
% zulsst. Auch mssen die Stichprobenwerte aus daten in Form eines Vektors
% vorliegen.
%
% Eingangsdaten:	  daten      Stichprobe (Vektor von Werten)
%
%                     prozent    Prozentzahl
%
% Ausgangsdaten:	  prctl      prozent-Perzentil
%
% Es werden i.W. keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 5.9.2004


if sum(size(daten)>[1,1])>=2   % daten kein Vektor
    error('prctileB kann fr daten nur vektorielle Argumente verarbeiten. Abbruch!');
end

% Daten aufsteigend sortieren
sdat = sort(daten);

% Perzentil berechnen

N = length(daten); indxvals = cumsum(ones(1,N));
indx = floor(N*prozent/100);
if indx == 0
    indx = 1;
end

v = sdat(indx);
tst = (sdat==v); tst = cumsum(cumsum(tst));
indx1 = indxvals(tst==1); 

if indx1 == N
    indx2 = N; 
else
    indx2 = indx1 + 1;
end

prctlu = sdat(indx1);
prctlo = sdat(indx2);
prctl = (prctlu+prctlo)/2;




