function [] = rcoplotB(residuen, VIResiduen)
%
% Funktion rcoplotB
%
% Aufruf: [] = rcoplotB(residuen, VIResiduen)
%
% Diese Funktion plottet die Werte aus Residuen und die Intervalle
% aus VIResiduen in form einer vertikalen Linie.
%
%
% Eingangsdaten:	  residuen   (nx1)-Vektor von Werten
%
%                     VIResiduen (nx2)-Matrix von Intervallgrenzen
%
%
% Ausgangsdaten:	  keine
%
% Es werden i.W. keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 5.9.2004

nargs = nargin;

if  nargs ~= 2 
    error('Aufrufstruktur von rcoplotB beachten. Abbruch!');
end

if sum(size(residuen)>[1,1])>=2   % residuen kein Vektor
    error('Erster Parameter von rcoplotB muss ein Vektor sein. Abbruch!');
end

residuen = residuen(:);
[ny,ry] = size(residuen);
[nX,rX] = size(VIResiduen);

if ny ~=nX | rX~=2                 % Dimensionen stimmen nicht
    error('Aufrufstruktur von rcoplotB beachten. Abbruch!');
end

% Vorinitialisierungen

unten = min(VIResiduen(:,1));
oben = max(VIResiduen(:,2));
indx = cumsum(ones(1,nX));
hold
h = scatter(indx, residuen, 'r');
set(h, 'LineWidth', 4);
for k=1:indx(end)
    h1 = line( [k, k], [VIResiduen(k,1), VIResiduen(k,2)]);
    set(h1, 'LineWidth', 3);
end

axis([0.5, indx(end)+0.5, unten, oben])
h2 = line([0.5, indx(end)+0.5], [0, 0]);
set(h2, 'Color', [0 0 0]);
ylabel('Residuen')
xlabel('Flle');

