function [pWert,TstErg,TestStat] = signrankB(x,y,alpha)
%
% Funktion signrankB
%
% Aufruf: [pWert,TstErg,TestStat] = signrankB(x,y,alpha)
%
% Diese Funktion realisiert Wilcoxons VORZEICHENRANGTEST fr VERBUNDENE 
% STICHPROBEN x und y.
%
% Die Funktion hat im Wesentlichen die gleiche Aufrufschnittstelle
% wie signrank und kann als ERSATZFUNKTION eingesetzt werden.
% Die Funktion hat gegenber signrank EINGESCHRNKTE FUNKTIONALITT.
%
% Eingangsdaten:	  x          Stichprobe (Vektor der Lnge n)
%
%                     y          Stichprobe (verbunden mit x, gleiche Lnge)
%
% Ausgangsdaten:	  pWert      die p-Wert
%                                  
%                     TstErg     Testergebnis (0=nicht abgelehnt, 1=abgelehnt)
%    
%                     TestStat   Struktur mit der Teststatistik
%
% Es werden nur wenige Fehleingaben abgefangen! 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 15.9.2004


if sum(size(x)>1)>1     % x kein Vektor
    error('x muss ein Vektor sein. Abbruch!');
end

if sum(size(y)>1)>1     % y kein Vektor
    error('y muss ein Vektor sein. Abbruch!');
end

x = x(:); y = y(:); n = length(x);

if length(x)~=length(y)          
    error('x und y mssen gleiche Lnge haben. Abbruch!');
end

if nargin==2
    alpha = 0.05;       % default-Testniveau
end

% Vorinitialisierungen

pWert = []; TstErg = [];
TestStat.Rangsummeplus = [];
TestStat.Rangsummeminus = [];
TestStat.TestVariable = [];
TestStat.pWert = [];
TestStat.TestErgebnis = [];


% Vorzeichen der Differenzen bestimmen

vz = (x-y)>=0;          % 1 positives Vorzeichen, 0 negatives Vorzeichen

% Absolutbetrge der Differenzen bestimmen

diffbetr = abs(x-y);

% Rnge (und Bindungen) bestimmen

[raenge, bndg] = getrnk(diffbetr);

% Rangsummen positiv und negativ bestimmen

TestStat.Rangsummeplus = sum(raenge(vz));
TestStat.Rangsummeminus = sum(raenge(~vz));

% Testgre ist der minimale Wert dieser beiden

TestStat.TestVariable = min(TestStat.Rangsummeplus, TestStat.Rangsummeminus);

% Fr groe Stichprobenumfnge ist die Testgre
% normalverteilt mit Mittelwert M und Varianz V

if n>15
    M = n*(n+1)/2; V = ((2*n+1)*(n+1)*n-sum(bndg))/24;
    pWert = 1-normcdf(TestStat.TestVariable,M,sqrt(V));
    TestStat.pWert = pWert; 
else

% Fr kleine Stichprobenumfnge ergibt sich die Verteilung
% aus kombinatorischen berlegungen zur Vorzeichenragverteilung

% Alle Kombinationen von Vorzeichen bestimmen
% (0 ist negativ, 1 ist positiv)
 
Rangtafel = vzkombi(n);

% p-Wert ermitteln
Rngfolge = Rangtafel(:,end);
anz = sum(TestStat.TestVariable >= Rngfolge);
pWert = 2*anz/length(Rngfolge);
TestStat.pWert = pWert; 
end

TstErg = pWert<alpha;

if TstErg
    TestStat.TestErgebnis = 'Die Nullhypothese wird abgelehnt!';
else
    TestStat.TestErgebnis = 'Die Nullhypothese wird nicht abgelehnt!';
end



















