function [Table] = tabulateB(x)
% 
% Funktion tabulateB
%
% Aufruf: [Table] = tabulateB(x)
%
% Diese Funktion erzeugt fr einen Vektor von positiven ganzen Zahlen
% eine Hufigkeitstafel.
%
% Eingangsdaten:	  x          Vektor von positiven ganzen Zahlen
%
% Ausgangsdaten:	  Table      Hufigkeitstafel
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.9.2004

if sum(size(x)>[1,1])>1     % x kein Vektor
    error('Das Argument von tabulateB nuss ein Vektor positiver ganzer Zahlen sein. Abbruch!');
end

if ~all ( abs(x-floor(x))<=eps ) | any(x<1)
    error('Das Argument von tabulateB nuss ein Vektor positiver ganzer Zahlen sein. Abbruch!');
end

Table = [cumsum(ones(1,max(x)))'];

hfg = [];
for k=1:max(x)
    hfg = [hfg, sum(Table(k,1)==x)];
end

hfgp = 100*hfg/sum(hfg);

Table = [Table, hfg' hfgp'];