function [arg] = tinvB(p,n)
%
% Funktion tinvB
%
% Aufruf: [arg] = tinvB(p,n)
%
% Diese Funktion realisiert die INVERSE kumulative t-Verteilung 
% mit n Freiheitsgraden (t-Quantile)
% (vgl. Abschnitt 2.7.2)
% Der Wert wird numerisch mit Hilfe der Funktion fzero ermittelt.
% Er kann daher in den Nachkommastellen vom Wert der TOOLBOX-Funktion
% tinv abweichen.
%
%
% Eingangsdaten:	  p          Wahrscheinlichkeit, fr die das einseitige
%                                Quantil arg mit P(X<=arg)=p gesucht werden soll
%
%                     n          Freiheitsgrad
%
% Ausgangsdaten:	  arg        Argument
%
% Es werden keine Fehleingaben abgefangen! 
%                                  
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004


if sum(size(p)~=[1,1])~=0     % p kein Skalar
    error('tinvB gestattet keine vektoriellen Argumente. Abbruch!');
end

optionen = optimset('DiffMaxChange',0.1);

% Bestimmung des Quantils

x0 = 1;                   % Startwert

arg = fzero(@tcdfBns,x0,optionen,p,n);







%------------------------------------------------------------
%
% Subfunction fr quivalentes Nullstellenproblem
%

function [y] = tcdfBns(x,p,n)
y = tcdfB(x,n)-p;