function [wD] = unifpdfB(x,a,b)
%
% Funktion unifpdfB
%
% Aufruf: [wD] = unifpdfB(x,a,b)
%
% Diese Funktion realisiert die Dichte Gleichverteilung im
% Intervall [a,b].
% (vgl. Abschnitt 2.3.2)
%
%
% Eingangsdaten:	  x          Wert, bei dem die Dichte der 
%                                Gleichverteilung berechnet werden soll
%
%                     a          linke Intervallgrenze
%                     b          rechte Intervallgrenze
%
% Ausgangsdaten:	  wD         Wert der Dichte bei x
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004


if b<=a
    error('Die linke Intervallgrenze muss kleiner als die rechte sein. Abbruch!');
end

faktor = 1/(b-a);
wD = faktor*(x>=a).*(x<=b);



