function Tbl = vzkombi(n)

% Tabelle vorinitialisieren mit Nullen

Tbl = zeros(2^n,n+1);
indx = cumsum(ones(1,n));
Tbl(1, n+1) = n*(n+1)/2; 

startindx = 2; 

for k=1:n
    Ck = nchoosek(indx,k);                % Positionen der Einsen
    [m,l] = size(Ck);
    for j=1:m
        Tbl(startindx, Ck(j,:))=1;        % Einsen setzen
                                          % Rangsumme der Nullen (negative VZ)
        Tbl(startindx, n+1) = n*(n+1)/2-sum(Ck(j,:));          
        startindx = startindx + 1;     
    end
end

Tbl = sortrows(Tbl,n+1);
