function [p] = weibcdfB(x,a,b)
%
% Funktion weicpdfB
%
% Aufruf: [p] = weibcdfB(x,a,b)
%
% Diese Funktion realisiert die kumulative Weibull-Verteilung mit 
% den Parametern a und b (vgl. Abschnitt 2.7.2)
%
%
% Eingangsdaten:	  x          Wert, bei dem die kumulative
%                                Weibull-Verteilung berechnet werden soll
%
%                     a          Zeitparameter; es gilt a = (1/T)^b, d.h. T^b = 1/a
%                                mit dem Zeitparameter T aus Abschnitt 2.7.2
%                     b          Formparameter
%
% Ausgangsdaten:	  p          P(X<=x), Wert der Verteilungsfunktion
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004


if a<=eps
    error('Der Zeitparameter a muss eine Zahl > 0 sein. Abbruch!');
end

if b<=eps
    error('Der Formparameter b muss eine Zahl > 0 sein. Abbruch!');
end

warning off
p = (x>=0).*(1-exp(-a*(x.^b)));

