function [wD] = weibpdfB(x,a,b)
%
% Funktion weibpdfB
%
% Aufruf: [wD] = weibpdfB(x,a,b)
%
% Diese Funktion realisiert die Dichte der Weibull-Verteilung mit 
% den Parametern a und b (vgl. Abschnitt 2.7.2)
%
%
% Eingangsdaten:	  x          Wert, bei dem die Dichte der 
%                                Weibull-Verteilung berechnet werden soll
%
%                     a          Zeitparameter; es gilt a = (1/T)^b, d.h. T^b = 1/a
%                                mit dem Zeitparameter T aus Abschnitt 2.7.2
%                     b          Formparameter
%
% Ausgangsdaten:	  wD         Wert der Dichte bei x
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004


if a<=eps
    error('Der Zeitparameter a muss eine Zahl > 0 sein. Abbruch!');
end

if b<=eps
    error('Der Formparameter b muss eine Zahl > 0 sein. Abbruch!');
end

warning off
wD = (x>=0).*(a*b).*x.^(b-1).*exp(-a*(x.^b));

