function [ydot] = zuintfdgl(t,y,Funkt,P2,P3)                  
%
% Funktion zuintfdgl    
%
% ODE-File der "Differentialgleichung" y = Funkt(x)
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 29.8.2004

% Vorinitialisierung   

nargs = nargin;
ydot = [0];

% Gleichung 

if nargs < 3
    error('zuintfdgl muss mindestens 3 Argumente haben. Abbruch!');
elseif nargs == 4
    ydot(1) = feval(Funkt,t,P2);
elseif nargs == 5  
    ydot(1) = feval(Funkt,t,P2,P3); 
else
    error('zuintfdgl hat mehr als 5 Argumente haben. Abbruch!');
end
z=0;

