function [thVals] = H0WeibullCombT1T2(params, daten)
%
% Funktion H0WeibullCombT1T2
%
% [thVals] = H0WeibullCombT1T2(params, daten)
%
% Funktion zur Berechnung der Werte der VerteilungsFUNKTION
% einer berlagerung von ZWEI Weibull-Verteilungen
% (Weibull-Mischverteilung) in Abhngigkeit von 
% params = [p, b1, T1, b2, T2] fr feste Werte p, b1 und b2, 
% die auf 1/4, 3/4 und 5 fixiert sind.
%
% Modell:  F(x) = p*fW(b1,T1)+(1-p)*fW(b2,T2)
%
% Eingabeparameter:    daten    Stichprobe der Lnge N
%
%                      params   Werte T1 und T2 der Parameter
%                               [p, b1, T1, b2, T2] 
%
% Ausgabeparameter:    thVals   Werte der Verteilungsfunktion
%                               bei den aufsteigend sortierten 
%                               Datenpunkten
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 29.01.2004

p = 1/4; b1 = 3/4; b2 = 5;

% Zeitparameter der Weibull-Verteilungen

T1 = params(1); T2 = params(2);

a1 = 1/(T1^b1);           % Anpassung der Parameter auf 
a2 = 1/(T2^b2);           % die MATLAB-Definition


% Sortieren der daten (gleiche Punkte werden NICHT eliminiert)

daten = sort(daten);

% Werte der Verteilungsfunktion an diesen Stellen

thVals = fWeibullComb(daten, [b1, T1, b2, T2], p);