% Skript-File: LinSmassUebung.m
%
% Aufruf: LinSmassUebung
%
% Das Skript-File berechnet die Dichte des Schliemaes fr eine
% bung zur statistischen Tolerierung einer linearen Makette mit 
% nicht-normalverteilten Maen.
%
% Die Makette ist M_s = - M_1 + M_2 - M_3
%
% Dabei ist
%
%      M1 dreiecksverteilt im Intervall [1.9, 2.0]
%      M2 dreiecksverteilt im Intervall [19.5, 20]
%      M3 gleichverteilt im Intervall [16.0, 16.4]
%
% Die Datei berechnet die Verteilungsdichte des Schliemaes und stellt
% das Ergebnis grafisch dar. Ferner werden der Mittelwert und die beidseitigen 
% 0.9973-Quantile berechnet.
%
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 21.3.2002


% Berechnung der Werte der Verteilungsdichten; alle Dichten 
% werden auf einen Mittelwert 0 zentriert und im Intervall 
% [-0.5, +0.5] mit einer Genauigkeitvon dx = 0.0001 dargestellt

dx = 0.0001;                         % Diskretisierungsschrittweite
interv = (-0.5:dx:0.5);              % Intervalldiskretisierung
m1 = triangpdf(interv,-0.05,+0.05);  % Dreieckverteilung 0-zentriert
m2 = triangpdf(interv,-0.25,+0.25);  % Dreieckverteilung 0-zentriert
m3 = unifpdfB(interv,-0.2,+0.2);     % Gleichverteilung 0-zentriert

% Faltung der drei Verteilungsdichten (beachte:
% fr die Approximation des INTEGRALS muss die 
% Diskretisierungsschrittweite mit multipliziert
% werden!

v1 = dx*conv(m1,m2);
verg = dx*conv(v1, m3);

% Berechnung des Vektors der Urbilder

N = (length(verg)-1)/2;
x = (-N*dx:dx:N*dx);

% Berechnung von Soll- und Mittelwert des Schliemaes

sollw = -2 + 20 - 16
mw = -1.95 + 20 - 16.25

% Verschiebung der Urbildwerte in den richtigen
% Wertebereich der Mae (des Schliemaes)

xSM = mw + x;

% Grafische Darstellung der Dichte des Schliemaes

plot(xSM,verg,'r-','LineWidth',5);
mx = max(verg);
axis([-N*dx+mw, N*dx+mw, 0, mx])
xlabel('x')
ylabel('f(x)')

% Berechnung der zweiseitigen 99.73-Quantile
% (Toleranzbereich); beachte: Verteilung hier symmetrisch,
% daher zweiseitiges 99.73%-Quantil = einseitiges 
% (1+0.9973)/2%-Quantil!

F = dx*cumtrapz(verg);   % Verteilungsfunktion
drunter = (F<(1-0.9973)/2);
drueber = (F>1-(1-0.9973)/2);
hlf = xSM((~drunter)&(~drueber));
GuStat = min(hlf)        % untere Toleranzgrenze
GoStat = max(hlf)        % obere Toleranzgrenze
TStat = GoStat-GuStat    % Toleranz



