% Script-File LsgAufgMCHyptest.m
%
% Aufruf:  LsgAufgMCHyptest
%
% Monte-Carlo-Hypothesen-Test. Es wird die Nullhypothese mu_2 = 9.8 fr
% den Modalwerte der Daten aus verbrauch.dat getestet.
% Der Schtzer ergibt sich aus dem Modalwert der Anpassung eines 
% Mischverteilungs-Modells an die Daten.
%
% Zur Modellanpassung wird die Funktion MModal3 verwendet, die 
% speziell auf die Klasseneinteilung dx = 0.1; und  klmitten = (7.5:dx:11.5);
% zugeschnitten ist und die Fixierung der brigen Parameter der Nullhypothese 
% bei der Schtzung von mu_2 bercksichtigt.
% 
% Das Script liefert als Ergebnis die Aussage, ob ie Nullypothese fr mu_2
% zum 95%-Niveau gehalten werden kann oder nicht.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 6.1.2004


load verbrauch.dat

% Global-Deklaration fr beta0 zur baergabe der
% Modellparameter an die Funktionen

global beta0

% Die Parameter der Nullhypothese

beta0 = [1/4, 8.5, 1/3, 9.8, 1/3];

% Die Klasseneinteilung fr die Anpassung des Modells

dx = 0.1;
klmitten = (7.5:dx:11.5);    

% Aufruf der Anpassungsfunktion zur Berechnung des 
% Parameters mu_2 fr die Daten aus verbrauch.dat
% Dies ist die Testgre

mu2Test = MModal3(verbrauch, klmitten);
fprintf('\nWert der Testvariablen:             %10.6f', mu2Test);

% Anzahl der Monte-Carlo-Simulationen festlegen

N = 1000;

% Berechnung der Stichproben fr jede MC-Simulation
% in einer Schleife mit anschlieender Berechnung des Parameters
% mu_2. Dabei wird jedes mal eine Stichprobe der gleichen
% Lnge wie verbrauch.dat gezogen

M = length(verbrauch);
ModW = [];

for k=1:N
    % Mit Hilfe des Zufallsgenerators eine Stichprobe
    % der Lnge M ziehen
    [probe] = BenzVerbrauchPdf(M, beta0);
    
    % Modalwert mu_2 auf der Grundlage dieser Stichprobe schtzen
    ModW = [ModW; MModal3(probe, klmitten)];
end;

% Zweiseitige alpha-Quantile der Modalwerte berechnen

alpha = 0.05;

Gu = prctileB(ModW,100*alpha/2);
Go = prctileB(ModW,100*(1-alpha/2));
fprintf('\nEmpirische 95-Prozent-Quantile:    [%10.6f, %10.6f]', Gu,Go);

% Testentscheidung treffen

H0 = (mu2Test>=Gu)&(mu2Test<=Go);   % Testgre innerhalb

if H0
    fprintf('\nDie Nullhypothese wird nicht abgelehnt!');
else
    fprintf('\nDie Nullhypothese wird zum 95-Prozent-Niveau abgelehnt!');
end;



