% Script-File LsgProbit.m
%
% Aufruf:  LsgProbit
%
% Beispiel zur VERALLGEMEINERTEN LINEAREN Regression.
% Es wird fr die Daten aus der Datei Kauf.dat ein PROBIT-Modell berechnet.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 30.11.2003

% Laden der Daten aus Kauf.dat

load Kauf.dat
x = Kauf(:,1); y = Kauf(:,2);

% Aufruf der Funktion glmfit zur Berechnung des Probit-Modells

beta = glmfitB(x,[y, ones(size(y))], 'binomial','probit',[],[],[],'on')

% Berechnung der Anpassungskurve und Darstellung mit den
% Daten aus Kauf.dat

yfit = glmvalB(beta,x,'probit');

scatter(x, y, 20, 'r-', 'filled');
xlabel('Jahreseinkommen/Euro')
hold
[xsort, Indx] = sort(x);       % Daten aufsteigend sortieren
plot(xsort, yfit(Indx), 'b-', 'LineWidth', 2);




