% Script-File LsgRegressKoeffTest.m
%
% Aufruf:  LsgRegressKoeffTest
%
% Beispiel zum Hypothesentest fr den konstanten Regressionskoeffizienten.
% Es wird ein Test der Nullhypothese
%
%        H0: b=0
%
% der Fahrzeugbreite-Wendekreisradius-Beziehung des Datensatzes CarDATA93cars.dat
% gegen die zweiseitige Alternative durchgefhrt!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 27.11.2003


% Laden des Datensatzes CarDATA93cars.dat

ReadCarData

% Zahl der Datenpunkte

n = length(Breite);

% "Fehler"quadratsumme der Einflusgre "Breite"
% (var berechnet empirische Varianz; siehe Definition)

ssx = (n-1)*var(Breite);

% Berechnung des arithmetischen Mittels der Einflussgren

xquer = mean(Breite);

% Berechnung der Regressionsparameter

X = [Breite, ones(length(Breite),1)];
beta = regressB(Wendekreis,X);

a = beta(1); b = beta(2);

% Berechnung der Residuenquadratsumme

ssr = sum( (Wendekreis - a*Breite - b).^2 );

% Berechnung des zweiseitigen alpha-Quantils der t-Verteilung
% mit (n-2) Freiheitsgeraden

alpha = 0.05;                    % Signifikanzniveau 5%
utilde = tinvB(1-alpha/2, n-2);

b_0 = 0;                         % ist die Nullhypothese !

H = abs(b) >  utilde*sqrt((1/n+xquer^2/ssx)*ssr/(n-2));


% Bestimmung des p-Wertes bei Gltigkeit von H0
      
                                 % Wert der Testvariablen
btilde = sqrt((n-2)/(ssr*(1/n+xquer^2/ssx)))*(b-b_0);   
                                 % Wkt abs(btilde) und grer
p = tcdfB(-abs(btilde),n-2) + (1-tcdfB(abs(btilde),n-2));


% Ausgabe des Ergebnisses

if H
    fprintf('\nDie Nullhypothese fr den konstanten Regressionskoeffizienten b wird abgelehnt!\n');
else
    fprintf('\nDie Nullhypothese fr den konstanten Regressionskoeffizienten b wird nicht abgelehnt!\n');
end;
    
fprintf('Der p-Wert ist %7.4f\n\n', p);
