function [a] = MCNLpA(M)
%
%
% Aufruf:  [a] = MCNLpA(M)
%
%
% Die vorliegende Funktion berechnet fr die Makette
%
% A = arctan( (M2+M3)/M1 )
%
% mit Hilfe der MONTE-CARLO-METHODE einen Schtzwert fr den Mittelwert
% a von A!!
% 
% Die Mae M2, M3, M1 sind dabei wie folgt verteilt:
% M3 ist N(0.5, (1/10)^2)-verteilt
% M2 ist gleichverteilt im Intervall [3/8, 5/8]
% M1 ist dreiecksverteilt im Intervall [5/6, 7/6]
%
% Eingabeparameter:    M        Anzahl der Monte-Carlo-Simulationen
%
%
% Ausgabeparameter:    a        berechnete a-Werte
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 15.12.2003


% Vorinitialisierungen

mu = 1/2; sigma = 0.1;            % Verteilungsparameter
gyu = 3/8; gyo = 5/8;
gzu = 5/6; gzo = 7/6;


A = [];                           % Werte fr die Schliemae

rand('state',sum(100*clock));     % Zufallsgenerator initialisieren

for k=1:M                         % Zahl der Iterationen
    M3 = normrndB(mu,sigma);      % Wert von M3
    M2 = unifrndB(gyu, gyo);      % Wert von M2
    M1 = triangrnd(1, gzu, gzo);  % Wert von M1
    
                                  % neuen Schliemawert berechnen
    A = [A, atan( (M2+M2)/M1 )];
end;

% Arithmetisches Mittel bilden

a = sum(A)/M;

